/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_slider_Thumb({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":null,"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Slider.html#Ext-slider-Thumb' target='_blank'>Slider.js</a></div></pre><div class='doc-contents'><p>Represents a single thumb element on a Slider. This would not usually be created manually and would instead\nbe created internally by an <a href=\"#!/api/Ext.slider.MultiSlider\" rel=\"Ext.slider.MultiSlider\" class=\"docClass\">Ext.Slider</a>.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-constrain' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-cfg-constrain' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-cfg-constrain' class='name expandable'>constrain</a><span> : Boolean</span></div><div class='description'><div class='short'>True to constrain the thumb so that it cannot overlap its siblings ...</div><div class='long'><p>True to constrain the thumb so that it cannot overlap its siblings</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-slider' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-cfg-slider' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-cfg-slider' class='name not-expandable'>slider</a><span> : <a href=\"#!/api/Ext.slider.MultiSlider\" rel=\"Ext.slider.MultiSlider\" class=\"docClass\">Ext.slider.MultiSlider</a></span></div><div class='description'><div class='short'><p>The Slider to render to (required)</p>\n</div><div class='long'><p>The Slider to render to (required)</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-dragging' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-property-dragging' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-property-dragging' class='name expandable'>dragging</a><span> : Boolean</span></div><div class='description'><div class='short'>True while the thumb is in a drag operation ...</div><div class='long'><p>True while the thumb is in a drag operation</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-slider' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-property-slider' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-property-slider' class='name not-expandable'>slider</a><span> : <a href=\"#!/api/Ext.slider.MultiSlider\" rel=\"Ext.slider.MultiSlider\" class=\"docClass\">Ext.slider.MultiSlider</a></span></div><div class='description'><div class='short'><p>The slider this thumb is contained within</p>\n</div><div class='long'><p>The slider this thumb is contained within</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-destroy' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Destroys the thumb ...</div><div class='long'><p>Destroys the thumb</p>\n</div></div></div><div id='method-disable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-disable' class='name expandable'>disable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Disables the thumb if it is currently enabled ...</div><div class='long'><p>Disables the thumb if it is currently enabled</p>\n</div></div></div><div id='method-enable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-enable' class='name expandable'>enable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Enables the thumb if it is currently disabled ...</div><div class='long'><p>Enables the thumb if it is currently disabled</p>\n</div></div></div><div id='method-getNewValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-getNewValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-getNewValue' class='name expandable'>getNewValue</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-initEvents' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-initEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-initEvents' class='name expandable'>initEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Sets up an Ext.dd.DragTracker for this thumb ...</div><div class='long'><p>Sets up an <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a> for this thumb</p>\n</div></div></div><div id='method-onBeforeDragStart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-onBeforeDragStart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-onBeforeDragStart' class='name expandable'>onBeforeDragStart</a>( <span class='pre'>e</span> ) : Boolean<strong class='private signature' >private</strong></div><div class='description'><div class='short'>This is tied into the internal Ext.dd.DragTracker. ...</div><div class='long'><p>This is tied into the internal <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a>. If the slider is currently disabled,\nthis returns false to disable the DragTracker too.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>False if the slider is currently disabled</p>\n</div></li></ul></div></div></div><div id='method-onDrag' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-onDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-onDrag' class='name expandable'>onDrag</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>This is tied into the internal Ext.dd.DragTracker's onDrag template method. ...</div><div class='long'><p>This is tied into the internal <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a>'s onDrag template method. This is called every time\nthe DragTracker detects a drag movement. It updates the Slider's value using the position of the drag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onDragEnd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-onDragEnd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-onDragEnd' class='name expandable'>onDragEnd</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>This is tied to the internal Ext.dd.DragTracker's onEnd template method. ...</div><div class='long'><p>This is tied to the internal <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a>'s onEnd template method. Removes the drag CSS class and\nfires the 'changecomplete' event with the new value</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onDragStart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-onDragStart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-onDragStart' class='name expandable'>onDragStart</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>This is tied into the internal Ext.dd.DragTracker's onStart template method. ...</div><div class='long'><p>This is tied into the internal <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a>'s onStart template method. Adds the drag CSS class\nto the thumb and fires the 'dragstart' event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-render' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.slider.Thumb'>Ext.slider.Thumb</span><br/><a href='source/Slider.html#Ext-slider-Thumb-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.slider.Thumb-method-render' class='name expandable'>render</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Renders the thumb into a slider ...</div><div class='long'><p>Renders the thumb into a slider</p>\n</div></div></div></div></div></div></div>","superclasses":[],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Slider.html#Ext-slider-Thumb","filename":"Slider.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.slider.Thumb","meta":{},"name":"dragging","id":"property-dragging"},{"tagname":"property","owner":"Ext.slider.Thumb","meta":{},"name":"slider","id":"property-slider"}],"cfg":[{"tagname":"cfg","owner":"Ext.slider.Thumb","meta":{},"name":"constrain","id":"cfg-constrain"},{"tagname":"cfg","owner":"Ext.slider.Thumb","meta":{},"name":"slider","id":"cfg-slider"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.slider.Thumb","meta":{"private":true},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{},"name":"disable","id":"method-disable"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{},"name":"enable","id":"method-enable"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{"private":true},"name":"getNewValue","id":"method-getNewValue"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{},"name":"initEvents","id":"method-initEvents"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{"private":true},"name":"onBeforeDragStart","id":"method-onBeforeDragStart"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{"private":true},"name":"onDrag","id":"method-onDrag"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{"private":true},"name":"onDragEnd","id":"method-onDragEnd"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{"private":true},"name":"onDragStart","id":"method-onDragStart"},{"tagname":"method","owner":"Ext.slider.Thumb","meta":{},"name":"render","id":"method-render"}],"event":[],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.slider.Thumb","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.slider.Thumb","mixins":[],"mixedInto":[]});